<?php
/*
 
 Template Name: Practice Areas Icon 3Col
 
 */

get_header(); ?>

<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' ); ?>

<?php $mt_page_title =  get_post_meta($post->ID, "mt_page_title", true); ?>

<section class="topSingleBkg topPageBkg <?php if(!empty($image)):?> topSingleBkgImg <?php endif;?>">  

<?php if(!empty($image)):?>

<div class="item-img" style="background-image:url('<?php echo esc_url($image[0]); ?>');"></div>

<?php endif;?>

  <div class="inner-desc">	 
  
 <h1 class="post-title single-post-title"><?php if(!empty($mt_page_title)): echo esc_html($mt_page_title); else: the_title(); endif;?></h1>
 
</div>

</section>

<?php if($post->post_content!="") : ?>

<section id="wrap-content" class="page-content">

<div class="container">
<div class="row">
<div class="col-md-12">

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div id="post-<?php the_ID(); ?>" class="page-holder custom-page-template page-full">

<?php the_content(); ?>

</div>
<?php  endwhile;

else: ?>

<p class="alignc"><?php esc_html_e( 'Sorry, but it seems we can&rsquo;t find what you&rsquo;re looking for. Try the menu above.', 'liberis' ); ?></p>

<?php endif; ?>

</div><!--col-md-12-->
</div><!--row-->
</div><!--container-->
</section>

<?php endif; ?>

<section class="layout-practice-areas-icon col3">

<div class="container">
<div class="row">
<div class="col-md-12">

<?php	global $wp_query;
   
   $paged = get_query_var('paged') ? get_query_var('paged') : 1;
		
	$defaults = array('post_type' => 'mt_practice_areas', 'posts_per_page' => 24, 'paged'=> $paged);
	$wp_query = new WP_Query($defaults);
		
	?>
 
 <div class="practice-icons-v1">
 
 <?php while (have_posts() ) : the_post(); ?>
    
    <?php $mt_practice_subtitle =  get_post_meta($post->ID, "mt_practice_subtitle", true);
		  $mt_practice_icon =  get_post_meta($post->ID, "mt_practice_icon", true);
	?>
    
    
 <div class="practice-icon-holder practice-icon-holder-3col">
 
 <div class="practice-icon-border">
 <?php if (!empty($mt_practice_icon)): ?>
 <div class="icon-top"><?php echo wp_kses_post( $mt_practice_icon ); ?></div>
 <?php endif; ?>
 
 <h2><a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a></h2>
 <?php if (!empty($mt_practice_subtitle)): ?>
<div class="practice-icon-subtitle"> <?php echo esc_html($mt_practice_subtitle); ?> </div>
<?php endif; ?>

<div class="practice-icon-content"><?php echo wp_trim_words( get_the_excerpt(), 10, '' ); ?></div>

<a class="read-more" href="<?php the_permalink() ?>"><?php esc_html_e('Read More', 'liberis')?> </a>

</div>

</div>
  
<?php endwhile; wp_reset_postdata(); ?>
 
 </div><!-- practice-icons-v1 -->
 
 <?php if(function_exists('liberis_pagenavi') ) : ?>

	<?php liberis_pagenavi();  ?>
        
	<?php else : ?>

  <ul class="other-entries">
			<li class="newer-entries"><span><?php previous_posts_link(esc_html__('Previous', 'liberis')); ?></span></li>
            <li class="older-entries"><span><?php next_posts_link(esc_html__('Next', 'liberis')); ?></span></li>
          </ul>
      
<?php endif; ?>    

</div><!--col-md-12-->
</div><!--row-->
</div><!--container-->
</section>

<?php get_footer(); ?>