<?php
/*
Template Name: Home v2

*/
?>

<?php get_header(); ?>

<?php $mt_slides = get_theme_mod( 'mt_slides', array() );

 if (!empty($mt_slides) ): ?>

<div class="slider-container">
<div class="owl-carousel owl-theme home-slider">

<?php foreach( $mt_slides as $mt_slide ): ?>   

      <div class="slider-post slider-item-box">
	  
	  <?php $mt_slide_img = wp_get_attachment_image_src( $mt_slide['mt_slide_image'] , 'full' ); ?>
        
     <div class="slider-img" style="background-image:url('<?php echo esc_url( $mt_slide_img[0] ); ?>');"></div>

	 <div class="slider-caption">
    
	<?php echo wp_kses_post( $mt_slide['mt_slide_text'] ); ?>
   
     </div><!--slider-caption-->

   </div>
   
   <?php endforeach; ?>

</div>
</div>

<?php endif; ?>


<section id="wrap-content" class="page-content">

<div class="container">
<div class="row">
<div class="col-md-12">

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div id="post-<?php the_ID(); ?>" class="page-holder custom-page-template page-full home-content">

<?php the_content(); ?>

</div>
<?php  endwhile;

else: ?>

<p class="alignc"><?php esc_html_e( 'Sorry, but it seems we can&rsquo;t find what you&rsquo;re looking for. Try the menu above.', 'liberis' ); ?></p>

<?php endif; ?>

</div><!--col-md-12-->
</div><!--row-->
</div><!--container-->
</section>

<?php get_footer(); ?>