<?php
/**
* The configuration options
*/

if ( class_exists( 'Kirki' ) ) {

	/**
	 * Add sections
	 */
	 
	 new \Kirki\Section(
	'mt_headers',
	[
		'title'       => esc_html__( 'Headers', 'liberis' ),		
		'priority'    => 50,
	]
	);
	
	new \Kirki\Section(
	'mt_general',
	[
		'title'       => esc_html__( 'General Options', 'liberis' ),		
		'priority'    => 52,
	]
	);

	new \Kirki\Section(
	'mt_typography_options',
	[
		'title'       => esc_html__( 'Typography', 'liberis' ),		
		'priority'    => 53,
	]
	);
	
	new \Kirki\Section(
	'mt_social_media',
	[
		'title'       => esc_html__( 'Social Media', 'liberis' ),		
		'priority'    => 54,
	]
	);
	 
/**
	 * Theme Options
	 
*/
	
	//Headers
	
	new \Kirki\Field\Radio(
	[
		'settings'    => 'mt_header_display',
		'label'       => esc_html__( 'Top Header Display', 'liberis' ),
		'section'     => 'mt_headers',
		'default'     => 'mt_header3',
		'choices'     => [
			'mt_header1'   => esc_html__( 'Top Header 1', 'liberis' ),
			'mt_header2' => esc_html__( 'Top Header 2', 'liberis' ),
			'mt_header3'  => esc_html__( 'Top Header 3', 'liberis' ),

		],
	]
	);
	
	new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'mt_header_fixed',
		'label'       => esc_html__( 'Fixed Top Header', 'liberis' ),
		'section'     => 'mt_headers',
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'liberis' ),
			'off' => esc_html__( 'Disable', 'liberis' ),
		],
	]
	);
	
	new \Kirki\Field\Textarea(
	[
		'settings'    => 'mt_header_email',
		'label'       => esc_html__( 'Email', 'liberis' ),
		'description' => esc_html__( 'Add email to the header / mobile menu', 'liberis' ),
		'section'     => 'mt_headers',
		'default'     => '',
	]
	);
	
	new \Kirki\Field\Textarea(
	[
		'settings'    => 'mt_header_phone',
		'label'       => esc_html__( 'Phone', 'liberis' ),
		'description' => esc_html__( 'Add phone to the header / mobile menu', 'liberis' ),
		'section'     => 'mt_headers',
		'default'     => '',
	]
	);
		
	new \Kirki\Field\Textarea(
	[
		'settings'    => 'mt_header_address',
		'label'       => esc_html__( 'Address', 'liberis' ),
		'description' => esc_html__( 'Add address to the header / mobile menu', 'liberis' ),
		'section'     => 'mt_headers',
		'default'     => '',
	]
	);
		
	// general options
	
	new \Kirki\Field\Repeater(
	[
		'settings' => 'mt_slides',
		'label'    => esc_html__( 'Home - Slider Items', 'liberis' ),
		'description' => esc_html__( 'Create home top slider. Add as much items as you want', 'liberis' ),
		'section'  => 'mt_general',
		'priority' => 1,
		'row_label'    => [
			'type'  => 'text',
			'value' => esc_html__( 'Slider Item', 'liberis' ),
		],
		'button_label' => esc_html__( 'Add New Slider Item', 'liberis' ),
		'default'  => [
			
		],
		'fields'   => [
			'mt_slide_text'   => [
				'type'        => 'textarea',
				'label'       => esc_html__( 'Slider Text', 'liberis' ),
				'description' => esc_html__( 'Add slider text', 'liberis' ),
				'default'     => '',
			],
			'mt_slide_image'    => [
				'type'        => 'image',
				'label'       => esc_html__( 'Slider Image', 'liberis' ),
				'description' => esc_html__( 'Upload image file', 'liberis' ),
				'default'     => '',
				'choices'     => [
					'save_as' => 'id',
				],
			],
		],
	]
	);
	
	new \Kirki\Field\Radio_Image(
	[
		'settings'    => 'mt_home_articles_layout',
		'label'       => esc_html__( 'Blog - Articles Layout', 'liberis' ),
		'description'     => esc_html__( 'Select the articles layout for blog page', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => 'mt_home_articles_layout_2col_grid',
		'choices'     => [
			'mt_home_articles_layout_1col' => get_template_directory_uri() . '/images/layouts/layout-1col.png',
			'mt_home_articles_layout_2col_grid' => get_template_directory_uri() . '/images/layouts/layout-2col.png',
			'mt_home_articles_layout_3col_grid' => get_template_directory_uri() . '/images/layouts/layout-3col.png',
			'mt_home_articles_layout_1col_list_left' => get_template_directory_uri() . '/images/layouts/layout-1col_list_left.png',
		],
	]
	);
	
	new \Kirki\Field\Radio_Image(
	[
		'settings'    => 'mt_sidebar',
		'label'       => esc_html__( 'Blog - Sidebar Display', 'liberis' ),
		'description'     => esc_html__( 'Select how do you want to display the sidebar for home / archive pages ( right / left / none )', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => 'mt_sidebar_no',
		'choices'     => [
			'mt_sidebar_right'   => get_template_directory_uri() . '/images/sidebar/sidebar-right.png',
			'mt_sidebar_left'   => get_template_directory_uri() . '/images/sidebar/sidebar-left.png',
			'mt_sidebar_no'   => get_template_directory_uri() . '/images/sidebar/sidebar-no.png',
		],
	]
	);
	
	new \Kirki\Field\Radio_Image(
	[
		'settings'    => 'mt_sidebar_single',
		'label'       => esc_html__( 'Single Blog Page - Sidebar Display', 'liberis' ),
		'description'     => esc_html__( 'Select how do you want to display the sidebar for single blog pages', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => 'mt_sidebar_single_no',
		'choices'     => [
			'mt_sidebar_single_right'   => get_template_directory_uri() . '/images/sidebar/sidebar-right.png',
			'mt_sidebar_single_left'   => get_template_directory_uri() . 	'/images/sidebar/sidebar-left.png',
			'mt_sidebar_single_no'   => get_template_directory_uri() . '/images/sidebar/sidebar-no.png',
		],
	]
	);
	
	new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'mt_single_related',
		'label'       => esc_html__( 'Single Blog Page - Related Posts', 'liberis' ),
		'description'     => esc_html__( 'Show/Hide bottom single related posts', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'liberis' ),
			'off' => esc_html__( 'Disable', 'liberis' ),
		],
	]
	);
	
	new \Kirki\Field\Image(
	[
		'settings'    => 'mt_practice_item_top_img',
		'label'       => esc_html__( 'Practice Item - Single Page Top Image', 'liberis' ),
		'description'     => esc_html__( 'Add top image to the single practice item page', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => '',
	]
	);
	
	new \Kirki\Field\Textarea(
	[
		'settings'    => 'mt_footer_copy',
		'label'       => esc_html__( 'Footer - Copyright', 'liberis' ),
		'description'     => esc_html__( 'Add footer copyright', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => '&copy; Liberis. Designed by MatchThemes.',
	]
	);
	
	new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'mt_scroll_top',
		'label'       => esc_html__( 'Scroll Top Button', 'liberis' ),
		'description'     => esc_html__( 'Show/Hide scroll to top button', 'liberis' ),
		'section'     => 'mt_general',
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'liberis' ),
			'off' => esc_html__( 'Disable', 'liberis' ),
		],
	]
	);
	
	//colors
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_body_text_color',
		'label'       => esc_html__( 'Body Text Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#5A5A5A',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_link_color',
		'label'       => esc_html__( 'Link Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#dfbf8f',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_heavy_color',
		'label'       => esc_html__( 'Heavy Color for Headings', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#252525',
		'priority'    => 20,
	]
	);
	
	//nav
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_menu_normal_color',
		'label'       => esc_html__( 'Menu Item - Normal State Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#252525',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_menu_hover_color',
		'label'       => esc_html__( 'Menu Item - Hover State Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#151515',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_submenu_bkg_color',
		'label'       => esc_html__( 'Menu Item - SubMenu Background Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#252525',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_submenu_normal_color',
		'label'       => esc_html__( 'Menu Item - SubMenu Normal Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#ffffff',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_submenu_hover_color',
		'label'       => esc_html__( 'Menu Item - SubMenu Hover Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#dfbf8f',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_footer_bkg_color',
		'label'       => esc_html__( 'Footer - Background Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#eaedee',
		'priority'    => 20,
	]
	);
	
	new \Kirki\Field\Color(
	[
		'settings'    => 'mt_footer_txt_color',
		'label'       => esc_html__( 'Footer - Text Color', 'liberis' ),
		'section'     => 'colors',
		'default'     => '#6A6A6A',
		'priority'    => 20,
	]
	);
	
		
	//typography
	
	new \Kirki\Field\Select(
	[
		'settings'    => 'mt_body_font',
		'label'       => esc_html__( 'Body - Font Family', 'liberis' ),
		'description'     => esc_html__( 'Select a font family from the Google Web Fonts', 'liberis' ),
		'section'     => 'mt_typography_options',
		'default'     => 'Lato',
		'choices'     => Kirki_Fonts::get_font_choices(),
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_body_font_weight',
		'label'    => esc_html__( 'Body - Font Weight', 'liberis' ),
		'description'     => esc_attr__( 'Add body font weights', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '300,400,700,900',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_body_font_size',
		'label'    => esc_html__( 'Body - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select body text font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '16',
	]
	);
	
	new \Kirki\Field\Select(
	[
		'settings'    => 'mt_titles_font',
		'label'       => esc_html__( 'Titles - Font Family', 'liberis' ),
		'description'     => esc_html__( 'Select a font family from the Google Web Fonts', 'liberis' ),
		'section'     => 'mt_typography_options',
		'default'     => 'Playfair Display',
		'choices'     => Kirki_Fonts::get_font_choices(),
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_titles_font_weight',
		'label'    => esc_html__( 'Titles - Font Weight', 'liberis' ),
		'description'     => esc_attr__( 'Add post titles font weights', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '400,700,400i,700i',
	]
	);
	
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_h1_size',
		'label'    => esc_html__( 'H1 - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select H1 heading font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '54',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_h2_size',
		'label'    => esc_html__( 'H2 - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select H2 heading font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '48',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_h3_size',
		'label'    => esc_html__( 'H3 - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select H3 heading font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '36',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_h4_size',
		'label'    => esc_html__( 'H4 - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select H4 heading font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '32',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_h5_size',
		'label'    => esc_html__( 'H5 - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select H5 heading font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '24',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_h6_size',
		'label'    => esc_html__( 'H6 - Font Size', 'liberis' ),
		'description'     => esc_attr__( 'Select H6 heading font size ( in px )', 'liberis' ),
		'section'  => 'mt_typography_options',
		'default'  => '16',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_facebook_url',
		'label'    => esc_html__( 'Facebook URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Facebook URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_twitter_url',
		'label'    => esc_html__( 'Twitter URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Twitter URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_instagram_url',
		'label'    => esc_html__( 'Instagram URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Instagram URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_linkedin_url',
		'label'    => esc_html__( 'Linkedin URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Linkedin URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_pinterest_url',
		'label'    => esc_html__( 'Pinterest URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Pinterest URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);	
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_youtube_url',
		'label'    => esc_html__( 'YouTube URL', 'liberis' ),
		'description'     => esc_attr__( 'Add YouTube URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_vimeo_url',
		'label'    => esc_html__( 'Vimeo URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Vimeo URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_dribbble_url',
		'label'    => esc_html__( 'Dribbble URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Dribbble URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);

	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_skype_url',
		'label'    => esc_html__( 'Skype URL', 'liberis' ),
		'description'     => esc_attr__( 'Add Skype URL', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);
	
	new \Kirki\Field\Text(
	[
		'settings' => 'mt_social_email_url',
		'label'    => esc_html__( 'Email Address', 'liberis' ),
		'description'     => esc_attr__( 'Add email address', 'liberis' ),
		'section'  => 'mt_social_media',
		'default'  => '',
	]
	);

}//endif