<?php

if ( ! function_exists( 'liberis_setup' ) ) :

function liberis_setup() {
	
	load_theme_textdomain('liberis', get_template_directory() . '/languages');
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );	
	
	// Register Post Thumbnail
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size(600,500,true);
	add_image_size( 'liberis-image600x500', 600, 500, true ); // for practice areas featured image

	register_nav_menus(	array(
			'primary-menu' => esc_html__( 'Primary Menu', 'liberis'),
		)
	);
	
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );	
	
	// Set up the WordPress core custom background feature
	add_theme_support( 'custom-background', apply_filters( 'liberis_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
	
	// Add theme support for selective refresh for widgets
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	// Add support for core custom logo
	add_theme_support( 'custom-logo', array(
		'height'      => 150,
		'width'       => 250,
		'flex-width'  => true,
		'flex-height' => true,
	) );
	
	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );
	
	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );
	
	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );
	
	// Add support for custom header
	add_theme_support( 'custom-header', array(
	'width'         => 1920,
	'height'        => 500,
	'default-image' => '',
	) );
	
	// Add support for editor styles.
	add_theme_support( 'editor-styles' );

	// Enqueue editor styles.
	add_editor_style( 'css/style-editor.css' );
	
}
endif;

add_action( 'after_setup_theme', 'liberis_setup' );

function liberis_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'liberis_content_width', 1170 );
}
add_action( 'after_setup_theme', 'liberis_content_width', 0 );

// 1. Hide ACF field group menu item
add_filter('acf/settings/show_admin', '__return_false');

// 2. Include ACF
include_once( get_theme_file_path('/include/theme-settings.php') );

/* TGM Plugin Activation */
include_once ( get_theme_file_path('/include/tgm-plugin/plugin-install.php') );

// Add Theme Live Customizer options
include_once ( get_theme_file_path('/include/customizer/kirki/kirki.php') );
include_once ( get_theme_file_path('/include/customizer/customizer-options.php') );
include_once ( get_theme_file_path('/include/customizer/customizer-live.php') );

//Fixed Top Header
include_once ( get_theme_file_path('/include/header-sticky.php') );

//Add Google Web Fonts

function liberis_fonts_url() {
    $font_url = '';
	
	$mt_body_font = get_theme_mod( 'mt_body_font', 'Lato');
	$mt_body_font_weight = get_theme_mod( 'mt_body_font_weight', '300,400,700,900');
	$mt_titles_font = get_theme_mod( 'mt_titles_font', 'Playfair Display');
	$mt_titles_font_weight = get_theme_mod( 'mt_titles_font_weight', '400,700,400i,700i');
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'liberis' ) ) {
	
	if ( $mt_body_font != $mt_titles_font ){
	
	 $font_url = add_query_arg( 'family', urlencode( $mt_body_font.':'.$mt_body_font_weight.'|'.$mt_titles_font.':'.$mt_titles_font_weight.'&display=swap'), "//fonts.googleapis.com/css" );
	
	}
	
	else{ $font_url = add_query_arg( 'family', urlencode( $mt_body_font.':'.$mt_body_font_weight.'&display=swap'), "//fonts.googleapis.com/css" );
	}
		
    }
    return $font_url;
}


function liberis_fonts_script() {

    wp_enqueue_style( 'liberis-fonts', liberis_fonts_url(), array(), null );
	
}
add_action( 'wp_enqueue_scripts', 'liberis_fonts_script' );

/**
* Enqueue editor styles for Gutenberg
*/
 
function liberis_editor_styles() {
	wp_enqueue_style('font-awesome1', get_theme_file_uri('/css/fontawesome/css/all.min.css'), array(), null);
    wp_enqueue_style( 'liberis-fonts', liberis_fonts_url(), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'liberis_editor_styles' );


//	Register and load front end JS and CSS files
if( !function_exists( 'liberis_scripts_init' ) ) {
    function liberis_scripts_init() {
	
		wp_enqueue_style('bootstrap', get_theme_file_uri('/css/bootstrap/css/bootstrap.min.css'), array(), null);
		wp_enqueue_style('font-awesome1', get_theme_file_uri('/css/fontawesome/css/all.min.css'), array(), null);
		wp_enqueue_style('owl-carousel', get_theme_file_uri('/js/owl-carousel/owl.carousel.min.css'), array(), null);
		wp_enqueue_style('liberis-style-css', get_parent_theme_file_uri('/style.css'), array(), null);	
		
	    wp_enqueue_script('easing', get_theme_file_uri('/js/jquery.easing.min.js'), array( 'jquery' ),null,true);
		wp_enqueue_script('owl-carousel', get_theme_file_uri('/js/owl-carousel/owl.carousel.min.js'), array( 'jquery' ),null,true);
		
      	wp_enqueue_script('liberis-init', get_theme_file_uri('/js/init.js'), array( 'jquery' ),null,true);
		
		if( is_single() ){
  			
			wp_enqueue_script('liberis-commentform', get_theme_file_uri('/js/commentform.js'), array( 'jquery', 'jquery-form' ),null,true);
			
			$translation_array = array( 'name_error' => esc_html__( 'Please fill the Name field!', 'liberis' ),
									'email_error' => esc_html__( 'Please fill the Email field!', 'liberis' ),
									'emailvalid_error' => esc_html__( 'Please provide a valid Email address!', 'liberis' ),
									'message_error' => esc_html__( 'Please fill the Message field!', 'liberis' ),
									'send_msg' => esc_html__( 'Sending comment...!', 'liberis' ),
									'msg_sent' => esc_html__( 'Comment sent', 'liberis' )
									 );
									 
		wp_localize_script( 'liberis-commentform', 'commFobject', $translation_array );
			
		}
		
	}
		
    
    add_action('wp_enqueue_scripts', 'liberis_scripts_init');
}

function liberis_comments_reply() {
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'comment_form_before', 'liberis_comments_reply' );

// Register Sidebars

function liberis_widgets_init() {
	
	//main sidebar
	register_sidebar(array(
		'id' => 'sidebar-1',
		'name' => esc_html__( 'Sidebar','liberis'),
		'description' => esc_html__( 'Main sidebar that appears on a normal page.','liberis' ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h5 class="widgettitle"><span>',
		'after_title' => '</span></h5>'
	));
	
	//footer 1
	register_sidebar(array(
		'name' => esc_html__( 'Footer 1','liberis'),
		'id' => 'footer-one',
		'description' => esc_html__( 'Widgets in this area are used in the first footer column','liberis' ),
		'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h5 class="widgettitle"><span>',
		'after_title' => '</span></h5>'
	));
	
	//footer 2
	register_sidebar(array(
		'name' => esc_html__( 'Footer 2','liberis'),
		'id' => 'footer-two',
		'description' => esc_html__( 'Widgets in this area are used in the second footer column','liberis' ),
		'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h5 class="widgettitle"><span>',
		'after_title' => '</span></h5>'
	));
	
	//footer 3
	register_sidebar(array(
		'name' => esc_html__( 'Footer 3','liberis'),
		'id' => 'footer-three',
		'description' => esc_html__( 'Widgets in this area are used in the third footer column','liberis' ),
		'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h5 class="widgettitle"><span>',
		'after_title' => '</span></h5>'
	));
	
	//footer 4
	register_sidebar(array(
		'name' => esc_html__( 'Footer 4','liberis'),
		'id' => 'footer-four',
		'description' => esc_html__( 'Widgets in this area are used in the fourth footer column','liberis' ),
		'before_widget' => '<div id="%1$s" class="widget widget-footer %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h5 class="widgettitle"><span>',
		'after_title' => '</span></h5>'
	));
	
	
}
add_action( 'widgets_init', 'liberis_widgets_init' );

// Excerpt Content
function liberis_excerpt_length( $length ) {
	return 60;
}
add_filter( 'excerpt_length', 'liberis_excerpt_length');

function liberis_excerpt_more( $more ) {
	return '...';
}
add_filter('excerpt_more', 'liberis_excerpt_more');


// Add Custom Image Size to Media

function liberis_custom_image_sizes( $sizes ) {

	$imgSizes = array(
        'liberis-image600x500' => esc_html__('Custom Size', 'liberis'),
    );
	
	$sizes = array_merge( $sizes,  $imgSizes );

    return $sizes;
}

add_filter( 'image_size_names_choose', 'liberis_custom_image_sizes' );

//page navigation
function liberis_pagenavi( $p = 2 ) { // pages will be show before and after current page
  if ( is_singular() ) return; // don't show in single page
  global $wp_query, $paged;
  $max_page = $wp_query->max_num_pages;
  
  if ( $max_page == 1 ) return; // don't show when only one page
  if ( empty( $paged ) ) $paged = 1;
  echo '<div class="prev-next">';
  echo '<span class="nav-page">';
  previous_posts_link(esc_html__('&larr; Newer', 'liberis'));
  echo '</span>';
  if ( $paged > $p + 1 ) liberis_p_link( 1 );
  if ( $paged > $p + 2 ) echo '<span class="more-pages">...</span>';
  for( $i = $paged - $p; $i <= $paged + $p; $i++ ) { // Middle pages
    if ( $i > 0 && $i <= $max_page ) $i == $paged ? print "<span class='page-numbers current-page'>{$i}</span> " : liberis_p_link( $i );
  }
  if ( $paged < $max_page - $p - 1 ) echo '<span class="more-pages">...</span>';
  if ( $paged < $max_page - $p ) liberis_p_link( $max_page );
  echo '<span class="nav-page">';
  next_posts_link(esc_html__('Older &rarr;', 'liberis'));
  echo '</span>';
  echo '</div><!--end-->';
}
function liberis_p_link( $i, $title = '' ) {
	echo "<a class='page-numbers' href='", esc_html( get_pagenum_link( $i ) ), "'>{$i}</a> ";
}

//create new comments output
function liberis_custom_comments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment-body <?php if ($comment->comment_approved == '0') echo 'pending-comment'; ?> clearfix">
                <div class="comment-details">
                    <div class="comment-avatar">
                        <?php echo get_avatar($comment, $size = '45'); ?>
                    </div><!-- /comment-avatar -->
                    
                    <div class="comment-right">
                    <section class="comment-author vcard">
                    <span class="author"><?php echo get_comment_author_link()?></span>
					<div class="comment-date"> <?php echo get_comment_date(); ?></div>
                    </section><!-- /comment-meta -->
                    <section class="comment-content">
    	                <div class="comment-text">
    	                    <?php comment_text() ?>
    	                </div><!-- /comment-text -->
    	                <h5 class="reply">
    	                    <?php comment_reply_link(array_merge( $args, array('reply_text' => esc_html__('Reply','liberis'),'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
    	                </h5><!-- /reply -->
                    </section><!-- /comment-content -->
                    
                   </div><!-- /comment-right -->
                    
				</div><!-- /comment-details -->
		</div><!-- /comment -->
<?php

} //end custom_comments()

//remove Elementor Font Awesome

add_action( 'elementor/frontend/after_register_styles',function() {
	foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
	}
}, 20 );

//remove Elementor Roboto fonts
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );