<?php
/**
 * Plugin Name: Aislin Classroom
 * Plugin URI:  http://wordpress.org/plugins
 * Description: Classes post type and Google Classroom integration.
 * Version:     1.0.2
 * Author:      Aislin Themes
 * Author URI:  http://themeforest.net/user/Aislin/portfolio
 * Domain Path: /languages
 */
add_action( 'plugins_loaded', 'aislin_classroom_init', 11 );

function aislin_classroom_init() {

	if ( ! class_exists( 'CPT' ) ) {
		return;
	}

	$GLOBALS['agc_course'] = null;
	
	require_once __DIR__ . '/vendor/autoload.php';
	require_once __DIR__ . '/inc/course-interface.php';
	require_once __DIR__ . '/inc/course-internal.php';
	require_once __DIR__ . '/inc/course.php';
	require_once __DIR__ . '/inc/google-classroom.php';
	require_once __DIR__ . '/inc/post-type.php';
	require_once __DIR__ . '/inc/template-manager.php';
	require_once __DIR__ . '/inc/helpers.php';
	require_once __DIR__ . '/inc/metaboxes.php';
	require_once __DIR__ . '/inc/admin.php';
	require_once __DIR__ . '/inc/init.php';

	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once __DIR__ . '/vc-addons/class-list/addon.php';
		require_once __DIR__ . '/vc-addons/course-carousel/addon.php';
	}

	add_action( 'wp', 'agc_init' );
	add_filter( 'post_subtitle', 'agc_filter_subtitle' );
	add_action( 'admin_notices', 'agc_admin_notice_course', 100 );
	add_action( 'dynamic_sidebar_before', 'agc_dynamic_sidebar_before' );

	// Needs to be set up after setup theme
	// to allow a child theme to filter names.
	add_action( 'after_setup_theme', array( 'Aislin_Classroom_Post_Type', 'create_post_type' ) );
	add_action( 'wp_head', array( 'Aislin_Classroom_Post_Type', 'structured_data' ) );
	add_action( 'wp_enqueue_scripts', array( 'Aislin_Classroom_Post_Type', 'scripts' ) );


	load_plugin_textdomain( 'aislin-classroom', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
