<?php

/**
 * SCSSPHP
 *
 * @copyright 2012-2020 Leaf Corcoran
 *
 * @license http://opensource.org/licenses/MIT MIT
 *
 * @link http://scssphp.github.io/scssphp
 */

namespace ScssPhp\ScssPhp\Ast;

use ScssPhp\ScssPhp\SourceSpan\FileSpan;

/**
 * An {@see AstNode} that just exposes a single span generated by a callback.
 *
 * @internal
 */
final class FakeAstNode implements AstNode
{
    /**
     * @var \Closure(): FileSpan
     */
    private readonly \Closure $callback;

    /**
     * @param callable(): FileSpan $callback
     */
    public function __construct(callable $callback)
    {
        $this->callback = $callback(...);
    }

    public function getSpan(): FileSpan
    {
        return ($this->callback)();
    }

    public function __toString(): string
    {
        return '';
    }
}
